local cNotePos = "none";
local isEnabled = false;

local middle = "middle";
local right = "right";
local left = "left";

defStrumXs = {
    defaultOpponentStrumX0,
    defaultOpponentStrumX1,
    defaultOpponentStrumX2,
    defaultOpponentStrumX3,
    defaultPlayerStrumX0,
    defaultPlayerStrumX1,
    defaultPlayerStrumX2,
    defaultPlayerStrumX3
};

function onCreatePost() 
    -- debugPrint(defaultPlayerStrumX0 - (defaultPlayerStrumX2 - 640));

    -- defStrumXs[0] = defaultOpponentStrumX0;
    -- defStrumXs[1] = defaultOpponentStrumX1;
    -- defStrumXs[2] = defaultOpponentStrumX2;
    -- defStrumXs[3] = defaultOpponentStrumX3;
    -- defStrumXs[4] = defaultPlayerStrumX0;
    -- defStrumXs[5] = defaultPlayerStrumX1;
    -- defStrumXs[6] = defaultPlayerStrumX2;
    -- defStrumXs[7] = defaultPlayerStrumX3;
end

function onStepHit()
    -- here for later
end

function onEvent(name, value1, value2)
    if (name == "Player Note Anchor") then
        -- value1 = note position
        local toPos = value1:lower();
        -- debugPrint(toPos);

        if (toPos == "left") or (toPos == "right") or (toPos == "middle") then 
            cNotePos = toPos;
        else
            cNotePos = toPos;
        end
    end
end

local lerpVal = 0.5;
function onUpdate(elapsed)
    local notePos = cNotePos:lower();

    isEnabled = notePos ~= "none";
    
    if isEnabled then
        if notePos == left then
            -->> default pos - 640
            for i = 4,7 do
                local defX = getStrumX(i);
                local curX = getPropertyFromGroup('strumLineNotes', i, 'x');
                setPropertyFromGroup('strumLineNotes', i, 'x', quad_in_out(curX, defX - 640, lerpVal));
            end
        elseif notePos == middle then
            -->> default pos - 466 (use default left and down pos + 50 for up and right)
            for i = 4,7 do
                local defX = getStrumX(i);
                local curX = getPropertyFromGroup('strumLineNotes', i, 'x');
                local toX = defX - 466;

                if (i == 6) or (i == 7) then 
                    toX = getStrumX(i - 2) + 50;
                end

                setPropertyFromGroup('strumLineNotes', i, 'x', quad_in_out(curX, toX, lerpVal));
            end
        elseif notePos == right then
            -->> default pos
            for i = 4,7 do
                local defX = getStrumX(i);
                local curX = getPropertyFromGroup('strumLineNotes', i, 'x');
                setPropertyFromGroup('strumLineNotes', i, 'x', quad_in_out(curX, defX, lerpVal));
            end
        end
    end
end

function getStrumX(i)
    -- if (i < 4) then 
    --     return _G["defaultOpponentStrumX" + tostring(i)];
    -- else
    --     debugPrint(_G["defaultPlayerStrumX" + tostring(i)]);
    --     return _G["defaultPlayerStrumX" + tostring(i)];
    -- end

    if (i == 4) then return defaultPlayerStrumX0; end
    if (i == 5) then return defaultPlayerStrumX1; end
    if (i == 6) then return defaultPlayerStrumX2; end
    if (i == 7) then return defaultPlayerStrumX3; end
end

-- borrowed lerp code
function lerp(a,b,t) return a * (1-t) + b * t end
function quadin(a, b, t) return lerp(a, b, t * t) end
function quad_in_out(a, b, t)
    if t <= 0.5 then
      return quadin(a, b, t*2) - (b-a)/2 -- scale by 2/0.5
    else
      return quadin(a, b, (1 - t)*2) + (b-a)/2 -- reverse and offset by 0.5
    end
  end