local shaderName = "ntsc"

function onCreate()
    luaDebugMode = false;
    shaderCoordFix()
    makeLuaSprite("shaderImage", "", 0, 0)
    makeGraphic("shaderImage", screenWidth, screenHeight)    
    setSpriteShader("shaderImage", shaderName)
    runHaxeCode([[
        var shader = "]] .. shaderName .. [[";
        game.initLuaShader(shader);
        var runtimeShader = game.createRuntimeShader(shader);
        game.camGame.setFilters([new ShaderFilter(runtimeShader)]);
        game.getLuaObject("shaderImage").shader = runtimeShader;
        game.camHUD.setFilters([new ShaderFilter(game.getLuaObject("shaderImage").shader)]);
        game.camOther.setFilters([new ShaderFilter(game.getLuaObject("shaderImage").shader)]);
        return;
    ]])
end

function onUpdate(elapsed)
    setShaderFloat("shaderImage", "iTime", os.clock())
end

function shaderCoordFix()
    runHaxeCode([[
        resetCache = function(obj) {
            if (obj == null || obj.filters == null) return;
            obj.__cacheBitmap = null;
            obj.__cacheBitmapData = null;
        }
        refreshShaders = function(_) {
            resetCache(game.camGame.flashSprite);
            resetCache(game.camHUD.flashSprite);
            resetCache(game.camOther.flashSprite);
        }
        FlxG.signals.gameResized.add(refreshShaders);
        refreshShaders(null);
        return;
    ]])
    local tempDestroy = onDestroy
    function onDestroy()
        runHaxeCode([[FlxG.signals.gameResized.remove(refreshShaders); return;]])
        if tempDestroy then tempDestroy() end
    end
end
